/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.outgoing;

import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.network.TranslationService;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class OutgoingMessageHandler {
    private static OutgoingMessageHandler instance;
    private final Queue<String> messageQueue = new ConcurrentLinkedQueue<String>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final long API_RATE_LIMIT_MS = 1300L;
    private final AtomicLong lastApiCallTime = new AtomicLong(0L);
    private boolean isProcessing = false;
    private boolean isSendingMessage = false;

    private OutgoingMessageHandler() {
        this.startMessageProcessor();
    }

    public static synchronized OutgoingMessageHandler getInstance() {
        if (instance == null) {
            instance = new OutgoingMessageHandler();
        }
        return instance;
    }

    public boolean isSendingProgrammatically() {
        return this.isSendingMessage;
    }

    public void handleOutgoingMessage(String message) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        this.messageQueue.add(message);
        ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u5c06\u6d88\u606f\u6dfb\u52a0\u5230\u53d1\u9001\u7ffb\u8bd1\u961f\u5217: '{}'", (Object)message);
        if (!this.isProcessing) {
            this.processNextMessage();
        }
    }

    private void startMessageProcessor() {
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (!this.messageQueue.isEmpty() && !this.isProcessing) {
                    this.processNextMessage();
                }
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("[\u53d1\u9001\u5904\u7406] \u5904\u7406\u53d1\u9001\u6d88\u606f\u961f\u5217\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private void processNextMessage() {
        String message = this.messageQueue.poll();
        if (message == null) {
            return;
        }
        this.isProcessing = true;
        long currentTime = System.currentTimeMillis();
        long lastCall = this.lastApiCallTime.get();
        long timeSinceLastCall = currentTime - lastCall;
        if (lastCall > 0L && timeSinceLastCall < 1300L) {
            long delay = 1300L - timeSinceLastCall;
            this.messageQueue.add(message);
            this.scheduler.schedule(() -> {
                this.isProcessing = false;
            }, delay, TimeUnit.MILLISECONDS);
            return;
        }
        this.lastApiCallTime.set(currentTime);
        String targetLanguage = ModConfig.getOutgoingTargetLanguage();
        ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u6b63\u5728\u7ffb\u8bd1\u6d88\u606f: '{}' \u5230 '{}'", (Object)message, (Object)targetLanguage);
        CompletableFuture<String> futureTranslation = TranslationService.translateAsync(message, "auto", targetLanguage);
        ((CompletableFuture)futureTranslation.thenAccept(translatedText -> {
            if (translatedText != null && !translatedText.isEmpty()) {
                if (translatedText.contains("\u514d\u8d39\u7528\u6237\u63a5\u53e3\u8bbf\u95ee\u9891\u7387") || translatedText.contains("something went wrong")) {
                    ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u68c0\u6d4b\u5230API\u9891\u7387\u9650\u5236\uff0c\u6d88\u606f\u5c06\u91cd\u65b0\u6392\u961f: '{}'", (Object)message);
                    this.messageQueue.add(message);
                    this.scheduler.schedule(() -> {
                        this.isProcessing = false;
                    }, 1300L, TimeUnit.MILLISECONDS);
                    return;
                }
                ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u7ffb\u8bd1\u7ed3\u679c: '{}' -> '{}'", (Object)message, translatedText);
                this.sendMessageToServer((String)translatedText);
            } else {
                ChatTranslatorMod.LOGGER.warn("[\u53d1\u9001\u5904\u7406] \u7ffb\u8bd1\u5931\u8d25\uff0c\u5c06\u53d1\u9001\u539f\u59cb\u6d88\u606f: '{}'", (Object)message);
                this.sendMessageToServer(message);
            }
            this.isProcessing = false;
        })).exceptionally(e -> {
            ChatTranslatorMod.LOGGER.error("[\u53d1\u9001\u5904\u7406] \u7ffb\u8bd1\u53d1\u751f\u9519\u8bef\uff0c\u5c06\u53d1\u9001\u539f\u59cb\u6d88\u606f", e);
            this.sendMessageToServer(message);
            this.isProcessing = false;
            return null;
        });
    }

    private void sendMessageToServer(String message) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null) {
            client.execute(() -> {
                try {
                    this.isSendingMessage = true;
                    if (message.startsWith("/")) {
                        String command = message.substring(1);
                        player.field_3944.method_45731(command);
                        ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u5df2\u53d1\u9001\u547d\u4ee4: '{}'", (Object)command);
                    } else {
                        player.field_3944.method_45729(message);
                        ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u5904\u7406] \u5df2\u53d1\u9001\u804a\u5929\u6d88\u606f: '{}'", (Object)message);
                    }
                }
                catch (Exception e) {
                    ChatTranslatorMod.LOGGER.error("[\u53d1\u9001\u5904\u7406] \u53d1\u9001\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
                finally {
                    this.isSendingMessage = false;
                }
            });
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.messageQueue.clear();
        this.isProcessing = false;
    }
}

