/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.network.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.network.api.TranslationAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class DefaultTranslator
implements TranslationAPI {
    private static final String API_URL = "https://translate.appworlds.cn";
    private static final Gson GSON = new Gson();

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws Exception {
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        if (!"zh-CN".equals(targetLanguage)) {
            ChatTranslatorMod.LOGGER.warn("\u76ee\u6807\u8bed\u8a00\u8bbe\u7f6e\u4e0d\u662f\u4e2d\u6587,\u5df2\u81ea\u52a8\u8c03\u6574\u4e3a\u4e2d\u6587");
            targetLanguage = "zh-CN";
        }
        String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8.toString());
        String requestUrl = String.format("%s?text=%s&from=%s&to=%s", API_URL, encodedText, sourceLanguage, targetLanguage);
        ChatTranslatorMod.LOGGER.info("[Default API] post:{}", (Object)requestUrl);
        URL url = new URL(requestUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String responseStr = response.toString();
            ChatTranslatorMod.LOGGER.info("[Default API] response:{}", (Object)responseStr);
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(responseStr, JsonObject.class);
            int code = jsonResponse.get("code").getAsInt();
            if (code == 200) {
                return jsonResponse.get("data").getAsString();
            }
            String errorMsg = jsonResponse.get("msg").getAsString();
            ChatTranslatorMod.LOGGER.error("[Default API] error: {}", (Object)errorMsg);
            return "\u7ffb\u8bd1\u9519\u8bef: " + errorMsg;
        }
        throw new Exception("\u7ffb\u8bd1API\u8bf7\u6c42\u5931\u8d25: " + responseCode);
    }

    @Override
    public String getName() {
        return "\u9ed8\u8ba4\u7ffb\u8bd1";
    }
}

