/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.network.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.network.api.TranslationAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class DeepLTranslator
implements TranslationAPI {
    private static final String API_URL = "https://api-free.deepl.com/v2/translate";
    private static final Gson GSON = new Gson();

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws Exception {
        String line;
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        String apiKey = ModConfig.getDeeplApiKey();
        if (apiKey.isEmpty()) {
            ChatTranslatorMod.LOGGER.error("[DeepL API] \u672a\u914d\u7f6eAPI\u5bc6\u94a5");
            return "\u8bf7\u5148\u5728\u914d\u7f6e\u4e2d\u8bbe\u7f6eDeepL\u7ffb\u8bd1API\u7684\u5bc6\u94a5";
        }
        String source = this.convertSourceLanguageCode(sourceLanguage);
        String target = this.convertTargetLanguageCode(targetLanguage);
        StringBuilder requestBody = new StringBuilder();
        requestBody.append("text=").append(URLEncoder.encode(text, StandardCharsets.UTF_8.toString()));
        if (!"auto".equals(source)) {
            requestBody.append("&source_lang=").append(source);
        }
        requestBody.append("&target_lang=").append(target);
        ChatTranslatorMod.LOGGER.info("[DeepL API] \u8bf7\u6c42\u53c2\u6570: {}", (Object)requestBody);
        URL url = new URL(API_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Authorization", "DeepL-Auth-Key " + apiKey);
        try (OutputStream os = connection.getOutputStream();){
            os.write(requestBody.toString().getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            JsonArray translations;
            String line2;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line2 = reader.readLine()) != null) {
                response.append(line2);
            }
            reader.close();
            String responseStr = response.toString();
            ChatTranslatorMod.LOGGER.info("[DeepL API] \u54cd\u5e94: {}", (Object)responseStr);
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(responseStr, JsonObject.class);
            if (jsonResponse.has("translations") && (translations = jsonResponse.getAsJsonArray("translations")).size() > 0) {
                JsonObject translation = translations.get(0).getAsJsonObject();
                String translatedText = translation.get("text").getAsString();
                return translatedText;
            }
            return "\u672a\u627e\u5230\u7ffb\u8bd1\u7ed3\u679c";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
        StringBuilder errorResponse = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            errorResponse.append(line);
        }
        reader.close();
        String errorStr = errorResponse.toString();
        ChatTranslatorMod.LOGGER.error("[DeepL API] \u9519\u8bef: {} - {}", (Object)responseCode, (Object)errorStr);
        throw new Exception("DeepL\u7ffb\u8bd1API\u8bf7\u6c42\u5931\u8d25: " + errorStr);
    }

    private String convertSourceLanguageCode(String languageCode) {
        if ("auto".equals(languageCode)) {
            return "auto";
        }
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("zh-CN", "ZH");
        codeMap.put("en-US", "EN");
        codeMap.put("ja-JP", "JA");
        codeMap.put("fr-FR", "FR");
        codeMap.put("de-DE", "DE");
        codeMap.put("es-ES", "ES");
        codeMap.put("it-IT", "IT");
        codeMap.put("nl-NL", "NL");
        codeMap.put("pl-PL", "PL");
        codeMap.put("pt-PT", "PT");
        codeMap.put("ru-RU", "RU");
        return codeMap.getOrDefault(languageCode, "EN");
    }

    private String convertTargetLanguageCode(String languageCode) {
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("zh-CN", "ZH");
        codeMap.put("en-US", "EN-US");
        codeMap.put("en-GB", "EN-GB");
        codeMap.put("ja-JP", "JA");
        codeMap.put("fr-FR", "FR");
        codeMap.put("de-DE", "DE");
        codeMap.put("es-ES", "ES");
        codeMap.put("it-IT", "IT");
        codeMap.put("nl-NL", "NL");
        codeMap.put("pl-PL", "PL");
        codeMap.put("pt-PT", "PT-PT");
        codeMap.put("pt-BR", "PT-BR");
        codeMap.put("ru-RU", "RU");
        return codeMap.getOrDefault(languageCode, "ZH");
    }

    @Override
    public String getName() {
        return "DeepL\u7ffb\u8bd1";
    }
}

