/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.network.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.network.api.TranslationAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class BaiduTranslator
implements TranslationAPI {
    private static final String API_URL = "https://fanyi-api.baidu.com/api/trans/vip/translate";
    private static final Gson GSON = new Gson();
    private static final Random RANDOM = new Random();

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws Exception {
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        String appId = ModConfig.getBaiduAppId();
        String secretKey = ModConfig.getBaiduSecretKey();
        if (appId.isEmpty() || secretKey.isEmpty()) {
            ChatTranslatorMod.LOGGER.error("[\u767e\u5ea6API] \u672a\u914d\u7f6eAppID\u6216\u5bc6\u94a5");
            return "\u8bf7\u5148\u5728\u914d\u7f6e\u4e2d\u8bbe\u7f6e\u767e\u5ea6\u7ffb\u8bd1API\u7684AppID\u548c\u5bc6\u94a5";
        }
        String from = this.convertLanguageCode(sourceLanguage);
        String to = this.convertLanguageCode(targetLanguage);
        String salt = String.valueOf(RANDOM.nextInt(10000));
        String sign = this.generateSign(appId, text, salt, secretKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", text);
        params.put("from", from);
        params.put("to", to);
        params.put("appid", appId);
        params.put("salt", salt);
        params.put("sign", sign);
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : params.entrySet()) {
            if (queryString.length() > 0) {
                queryString.append("&");
            }
            queryString.append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString()));
        }
        String requestUrl = "https://fanyi-api.baidu.com/api/trans/vip/translate?" + String.valueOf(queryString);
        ChatTranslatorMod.LOGGER.info("[\u767e\u5ea6API] \u8bf7\u6c42: {}", (Object)requestUrl);
        URL url = new URL(API_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        try (OutputStream os = connection.getOutputStream();){
            os.write(queryString.toString().getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            JsonArray transResults;
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String responseStr = response.toString();
            ChatTranslatorMod.LOGGER.info("[\u767e\u5ea6API] \u54cd\u5e94: {}", (Object)responseStr);
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(responseStr, JsonObject.class);
            if (jsonResponse.has("error_code")) {
                String errorCode = jsonResponse.get("error_code").getAsString();
                String errorMsg = jsonResponse.get("error_msg").getAsString();
                ChatTranslatorMod.LOGGER.error("[\u767e\u5ea6API] \u9519\u8bef: {} - {}", (Object)errorCode, (Object)errorMsg);
                return "\u7ffb\u8bd1\u9519\u8bef: " + errorMsg;
            }
            if (jsonResponse.has("trans_result") && (transResults = jsonResponse.getAsJsonArray("trans_result")).size() > 0) {
                JsonObject result = transResults.get(0).getAsJsonObject();
                String translatedText = result.get("dst").getAsString();
                return translatedText;
            }
            return "\u672a\u627e\u5230\u7ffb\u8bd1\u7ed3\u679c";
        }
        throw new Exception("\u767e\u5ea6\u7ffb\u8bd1API\u8bf7\u6c42\u5931\u8d25: " + responseCode);
    }

    private String generateSign(String appId, String query, String salt, String secretKey) throws Exception {
        String source = appId + query + salt + secretKey;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = md.digest(source.getBytes(StandardCharsets.UTF_8));
        StringBuilder sign = new StringBuilder();
        for (byte b : bytes) {
            sign.append(String.format("%02x", b & 0xFF));
        }
        return sign.toString();
    }

    private String convertLanguageCode(String languageCode) {
        if ("auto".equals(languageCode)) {
            return "auto";
        }
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("zh-CN", "zh");
        codeMap.put("en-US", "en");
        codeMap.put("ja-JP", "jp");
        codeMap.put("ko-KR", "kor");
        codeMap.put("fr-FR", "fra");
        codeMap.put("es-ES", "spa");
        codeMap.put("ru-RU", "ru");
        return codeMap.getOrDefault(languageCode, languageCode);
    }

    @Override
    public String getName() {
        return "\u767e\u5ea6\u7ffb\u8bd1";
    }
}

