/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.network;

import com.google.gson.Gson;
import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.network.api.BaiduTranslator;
import com.trator.chatranslator.network.api.DeepLTranslator;
import com.trator.chatranslator.network.api.DefaultTranslator;
import com.trator.chatranslator.network.api.TranslationAPI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TranslationService {
    private static final Gson GSON = new Gson();
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor();
    private static long lastRequestTime = 0L;
    private static final long MIN_REQUEST_INTERVAL = 2000L;
    private static final TranslationAPI DEFAULT_API = new DefaultTranslator();
    private static final TranslationAPI BAIDU_API = new BaiduTranslator();
    private static final TranslationAPI DEEPL_API = new DeepLTranslator();

    public static CompletableFuture<String> translateAsync(String text) {
        return TranslationService.translateAsync(text, ModConfig.getSourceLanguage(), ModConfig.getTargetLanguage());
    }

    public static CompletableFuture<String> translateAsync(String text, String sourceLanguage, String targetLanguage) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (text == null || text.trim().isEmpty()) {
                    return text;
                }
                long currentTime = System.currentTimeMillis();
                long timeSinceLastRequest = currentTime - lastRequestTime;
                if (timeSinceLastRequest < 2000L) {
                    Thread.sleep(2000L - timeSinceLastRequest);
                }
                String result = TranslationService.translate(text, sourceLanguage, targetLanguage);
                lastRequestTime = System.currentTimeMillis();
                ChatTranslatorMod.LOGGER.info("result: [{}] -> [{}]", (Object)text, (Object)result);
                return result;
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("something went wrong", (Throwable)e);
                return "something went wrong:" + e.getMessage();
            }
        }, EXECUTOR);
    }

    private static String translate(String text) throws Exception {
        return TranslationService.translate(text, ModConfig.getSourceLanguage(), ModConfig.getTargetLanguage());
    }

    private static String translate(String text, String sourceLanguage, String targetLanguage) throws Exception {
        String apiType;
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        return (switch (apiType = ModConfig.getTranslationAPI()) {
            case "baidu" -> BAIDU_API;
            case "deepl" -> DEEPL_API;
            default -> DEFAULT_API;
        }).translate(text, sourceLanguage, targetLanguage);
    }
}

