/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.mixin;

import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.outgoing.OutgoingMessageHandler;
import java.util.regex.Pattern;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public class ClientPlayNetworkHandlerMixin {
    private static final Pattern ENGLISH_PATTERN = Pattern.compile("^[a-zA-Z\\s,\\.\\?!;:'\"\\-]+$");

    @Inject(method={"sendChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChatMessage(String message, CallbackInfo ci) {
        try {
            if (OutgoingMessageHandler.getInstance().isSendingProgrammatically()) {
                ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u62e6\u622a] \u68c0\u6d4b\u5230\u7a0b\u5e8f\u53d1\u9001\u7684\u6d88\u606f\uff0c\u8df3\u8fc7\u62e6\u622a: '{}'", (Object)message);
                return;
            }
            if (ModConfig.isTranslationEnabled() && ModConfig.isTranslateOutgoingMessagesEnabled()) {
                if (message.startsWith("/")) {
                    ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u62e6\u622a] \u68c0\u6d4b\u5230\u547d\u4ee4\uff0c\u8df3\u8fc7\u7ffb\u8bd1: '{}'", (Object)message);
                    return;
                }
                String targetLang = ModConfig.getOutgoingTargetLanguage();
                if (targetLang.startsWith("en") && ENGLISH_PATTERN.matcher(message).matches()) {
                    ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u62e6\u622a] \u68c0\u6d4b\u5230\u82f1\u6587\u6d88\u606f\u4e14\u76ee\u6807\u8bed\u8a00\u4e3a\u82f1\u6587\uff0c\u8df3\u8fc7\u7ffb\u8bd1: '{}'", (Object)message);
                    return;
                }
                ChatTranslatorMod.LOGGER.info("[\u53d1\u9001\u62e6\u622a] \u62e6\u622a\u7528\u6237\u53d1\u9001\u7684\u6d88\u606f: '{}'", (Object)message);
                ci.cancel();
                OutgoingMessageHandler.getInstance().handleOutgoingMessage(message);
            }
        }
        catch (Exception e) {
            ChatTranslatorMod.LOGGER.error("\u5904\u7406\u53d1\u9001\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

