/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.data;

import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.data.MessageData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageManager {
    private static final Map<String, MessageData> messageMap = new ConcurrentHashMap<String, MessageData>();
    private static final Map<String, String> messageSenderMap = new ConcurrentHashMap<String, String>();
    private static final int MAX_MESSAGES = 1000;

    public static MessageData addMessage(String original, String translated) {
        return MessageManager.addMessage(original, translated, null);
    }

    public static MessageData addMessage(String original, String translated, String sender) {
        if (messageMap.size() > 1000) {
            ChatTranslatorMod.LOGGER.info("\u6d88\u606f\u7f13\u5b58\u5df2\u6ee1\uff0c\u6b63\u5728\u6e05\u7406\u65e7\u6d88\u606f\u6570\u636e");
            messageMap.clear();
            messageSenderMap.clear();
        }
        MessageData messageData = new MessageData(original, translated);
        String messageId = messageData.getId();
        messageMap.put(messageId, messageData);
        if (sender != null && !sender.isEmpty()) {
            messageSenderMap.put(messageId, sender);
        }
        return messageData;
    }

    public static void setMessageSender(String messageId, String sender) {
        if (messageId != null && sender != null && !sender.isEmpty()) {
            messageSenderMap.put(messageId, sender);
        }
    }

    public static String getMessageSender(String messageId) {
        return messageSenderMap.get(messageId);
    }

    public static MessageData getMessage(String id) {
        return messageMap.get(id);
    }

    public static MessageData toggleMessageDisplay(String id) {
        MessageData messageData = messageMap.get(id);
        if (messageData != null) {
            messageData.toggleDisplay();
            ChatTranslatorMod.LOGGER.info("\u5207\u6362\u6d88\u606f\u663e\u793a: ID={}, \u5f53\u524d\u663e\u793a={}", (Object)id, (Object)(messageData.isShowTranslated() ? "\u7ffb\u8bd1" : "\u539f\u6587"));
        } else {
            ChatTranslatorMod.LOGGER.warn("\u65e0\u6cd5\u5207\u6362\u6d88\u606f\u663e\u793a: \u672a\u627e\u5230ID={}", (Object)id);
        }
        return messageData;
    }

    public static void clearMessages() {
        messageMap.clear();
        messageSenderMap.clear();
        ChatTranslatorMod.LOGGER.info("\u5df2\u6e05\u9664\u6240\u6709\u5b58\u50a8\u7684\u6d88\u606f\u6570\u636e");
    }
}

