/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.data;

import java.util.UUID;

public class MessageData {
    private final String id = UUID.randomUUID().toString();
    private final String originalText;
    private final String translatedText;
    private boolean showTranslated;

    public MessageData(String originalText, String translatedText) {
        this.originalText = originalText;
        this.translatedText = translatedText;
        this.showTranslated = true;
    }

    public String getId() {
        return this.id;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getTranslatedText() {
        return this.translatedText;
    }

    public boolean isShowTranslated() {
        return this.showTranslated;
    }

    public void toggleDisplay() {
        this.showTranslated = !this.showTranslated;
    }

    public String getCurrentText() {
        return this.showTranslated ? this.translatedText : this.originalText;
    }
}

