/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.trator.chatranslator.ChatTranslatorMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("chatranslator.json").toFile();
    private static ConfigData configData;

    public static void init() {
        if (!CONFIG_FILE.exists()) {
            configData = new ConfigData();
            ModConfig.save();
        } else {
            ModConfig.load();
        }
    }

    public static void load() {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
        }
        catch (IOException e) {
            ChatTranslatorMod.LOGGER.error("failed to load config", (Throwable)e);
            configData = new ConfigData();
        }
    }

    public static void save() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)configData, (Appendable)writer);
            }
        }
        catch (IOException e) {
            ChatTranslatorMod.LOGGER.error("failed to save config", (Throwable)e);
        }
    }

    public static void resetToDefault() {
        configData = new ConfigData();
        ModConfig.save();
    }

    public static boolean isTranslationEnabled() {
        return ModConfig.configData.translationEnabled;
    }

    public static void toggleTranslation() {
        ModConfig.configData.translationEnabled = !ModConfig.configData.translationEnabled;
        ModConfig.save();
    }

    public static String getSourceLanguage() {
        return ModConfig.configData.sourceLanguage;
    }

    public static String getTargetLanguage() {
        return ModConfig.configData.targetLanguage;
    }

    public static boolean shouldShowOriginalMessage() {
        return ModConfig.configData.showOriginalMessage;
    }

    public static int getTranslationDelay() {
        return ModConfig.configData.translationDelay;
    }

    public static void setTranslationEnabled(boolean enabled) {
        ModConfig.configData.translationEnabled = enabled;
        ModConfig.save();
    }

    public static void setSourceLanguage(String language) {
        ModConfig.configData.sourceLanguage = language;
        ModConfig.save();
    }

    public static void setTargetLanguage(String language) {
        ModConfig.configData.targetLanguage = language;
        ModConfig.save();
    }

    public static void setShowOriginalMessage(boolean show) {
        ModConfig.configData.showOriginalMessage = show;
        ModConfig.save();
    }

    public static void setTranslationDelay(int delay) {
        ModConfig.configData.translationDelay = delay;
        ModConfig.save();
    }

    public static String getTranslationAPI() {
        return ModConfig.configData.translationAPI;
    }

    public static void setTranslationAPI(String api) {
        ModConfig.configData.translationAPI = api;
        ModConfig.save();
    }

    public static String getBaiduAppId() {
        return ModConfig.configData.baiduAppId;
    }

    public static String getBaiduSecretKey() {
        return ModConfig.configData.baiduSecretKey;
    }

    public static void setBaiduAppId(String appId) {
        ModConfig.configData.baiduAppId = appId;
        ModConfig.save();
    }

    public static void setBaiduSecretKey(String secretKey) {
        ModConfig.configData.baiduSecretKey = secretKey;
        ModConfig.save();
    }

    public static String getDeeplApiKey() {
        return ModConfig.configData.deeplApiKey;
    }

    public static void setDeeplApiKey(String apiKey) {
        ModConfig.configData.deeplApiKey = apiKey;
        ModConfig.save();
    }

    public static boolean isTranslateOutgoingMessagesEnabled() {
        return ModConfig.configData.translateOutgoingMessages;
    }

    public static void toggleTranslateOutgoingMessages() {
        ModConfig.configData.translateOutgoingMessages = !ModConfig.configData.translateOutgoingMessages;
        ModConfig.save();
    }

    public static void setTranslateOutgoingMessages(boolean enabled) {
        ModConfig.configData.translateOutgoingMessages = enabled;
        ModConfig.save();
    }

    public static String getOutgoingTargetLanguage() {
        return ModConfig.configData.outgoingTargetLanguage;
    }

    public static void setOutgoingTargetLanguage(String language) {
        ModConfig.configData.outgoingTargetLanguage = language;
        ModConfig.save();
    }

    public static class ConfigData {
        public boolean translationEnabled = true;
        public String sourceLanguage = "auto";
        public String targetLanguage = "zh-CN";
        public boolean showOriginalMessage = false;
        public int translationDelay = 0;
        public boolean translateOutgoingMessages = false;
        public String outgoingTargetLanguage = "en";
        public String translationAPI = "default";
        public String baiduAppId = "";
        public String baiduSecretKey = "";
        public String deeplApiKey = "";
    }
}

