/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.network.TranslationService;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TranslateCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"translate").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> TranslateCommand.executeTranslate((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text")))));
        ChatTranslatorMod.LOGGER.info("command registered");
    }

    private static int executeTranslate(CommandContext<FabricClientCommandSource> context, String text) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"traslating:").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1068)));
        ((CompletableFuture)TranslationService.translateAsync(text).thenAccept(translatedText -> {
            if (translatedText != null && !translatedText.isEmpty()) {
                class_5250 resultText = class_2561.method_43470((String)"result:").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)translatedText).method_27692(class_124.field_1068));
                source.sendFeedback((class_2561)resultText);
            } else {
                source.sendError((class_2561)class_2561.method_43470((String)"something went wrong").method_27692(class_124.field_1061));
            }
        })).exceptionally(e -> {
            source.sendError((class_2561)class_2561.method_43470((String)("something went wrong" + e.getMessage())).method_27692(class_124.field_1061));
            ChatTranslatorMod.LOGGER.error("something went wrong", e);
            return null;
        });
        return 1;
    }
}

