/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator;

import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.data.MessageData;
import com.trator.chatranslator.data.MessageManager;
import com.trator.chatranslator.network.TranslationService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ChatMessageProcessor {
    private static final Pattern SYSTEM_MESSAGE_PATTERN = Pattern.compile("^\\[\u7cfb\u7edf\\]|^\\[\u8bd1\\]|^\\[\u539f\u6587\\]|^\\[\u539f\\]|^.+\u52a0\u5165\u4e86\u6e38\u620f$|^.+\u79bb\u5f00\u4e86\u6e38\u620f$|^\u672c\u5730\u6e38\u620f\u5df2\u5728\u7aef\u53e3");
    private static final Pattern PLAYER_MESSAGE_PATTERN = Pattern.compile(".*<([^>]+)>\\s+(.+)");
    private static final Pattern PREFIXED_CHAT_PATTERN = Pattern.compile("\\[.*?\\]\\s*<([^>]+)>\\s+(.+)");
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^/.*");
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final Set<String> CHINESE_ABBREVIATIONS = new HashSet<String>(){
        {
            this.add("gg");
            this.add("nb");
            this.add("xswl");
            this.add("nmsl");
            this.add("sb");
            this.add("lz");
            this.add("fvv");
            this.add("fw");
            this.add("233");
            this.add("666");
        }
    };
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final long API_RATE_LIMIT_MS = 1300L;
    private final AtomicLong lastApiCallTime = new AtomicLong(0L);
    private final Set<String> pendingTranslations = ConcurrentHashMap.newKeySet();
    private final Map<String, String> messageSenders = new ConcurrentHashMap<String, String>();

    public ChatMessageProcessor() {
        ChatTranslatorMod.LOGGER.info("\u804a\u5929\u6d88\u606f\u5904\u7406\u5668\u5df2\u521d\u59cb\u5316");
    }

    public void processMessage(String content, class_2561 originalMessage) {
        try {
            ChatTranslatorMod.LOGGER.info("\u5904\u7406\u6d88\u606f: '{}'", (Object)content);
            if (!ModConfig.isTranslationEnabled()) {
                ChatTranslatorMod.LOGGER.info("\u7ffb\u8bd1\u529f\u80fd\u5df2\u7981\u7528\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (this.isSystemMessage(content)) {
                ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u7cfb\u7edf\u6d88\u606f\uff0c\u8df3\u8fc7\u5904\u7406: '{}'", (Object)content);
                return;
            }
            if (this.isOwnTranslatedMessage(content)) {
                ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u5df2\u7ffb\u8bd1\u6d88\u606f\uff0c\u8df3\u8fc7\u5904\u7406: '{}'", (Object)content);
                return;
            }
            String[] extracted = this.extractPlayerMessage(content);
            if (extracted == null) {
                ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u5176\u4ed6\u6d88\u606f\u683c\u5f0f: '{}'", (Object)content);
                return;
            }
            String playerName = extracted[0];
            String messageContent = extracted[1];
            if (this.isCurrentPlayer(playerName)) {
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)messageContent);
                return;
            }
            if (this.isCommand(messageContent)) {
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)messageContent);
                return;
            }
            if (this.shouldSkipTranslation(messageContent)) {
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u8df3\u8fc7\u4e2d\u6587\u5185\u5bb9: '{}'", (Object)messageContent);
                return;
            }
            this.messageSenders.put(messageContent, playerName);
            ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u6b63\u5728\u7ffb\u8bd1: '{}'", (Object)messageContent);
            if (!this.pendingTranslations.contains(messageContent)) {
                this.pendingTranslations.add(messageContent);
                this.translateMessage(messageContent);
            } else {
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u5df2\u5728\u7ffb\u8bd1\u961f\u5217\u4e2d: '{}'", (Object)messageContent);
            }
        }
        catch (Exception e) {
            ChatTranslatorMod.LOGGER.error("\u5904\u7406\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private String[] extractPlayerMessage(String content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        Matcher prefixedMatcher = PREFIXED_CHAT_PATTERN.matcher(content);
        if (prefixedMatcher.find() && prefixedMatcher.groupCount() >= 2) {
            String playerName = prefixedMatcher.group(1);
            String messageContent = prefixedMatcher.group(2).trim();
            ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u4ece\u5e26\u524d\u7f00\u6d88\u606f\u63d0\u53d6: '{}' \u8bf4: '{}'", (Object)playerName, (Object)messageContent);
            return new String[]{playerName, messageContent};
        }
        Matcher standardMatcher = PLAYER_MESSAGE_PATTERN.matcher(content);
        if (standardMatcher.find() && standardMatcher.groupCount() >= 2) {
            String playerName = standardMatcher.group(1);
            String messageContent = standardMatcher.group(2).trim();
            ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u4ece\u6807\u51c6\u683c\u5f0f\u63d0\u53d6: '{}' \u8bf4: '{}'", (Object)playerName, (Object)messageContent);
            return new String[]{playerName, messageContent};
        }
        if (content.contains("<") && content.contains(">")) {
            int startIndex = content.lastIndexOf(60);
            int endIndex = content.indexOf(62, startIndex);
            if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                String playerName = content.substring(startIndex + 1, endIndex);
                String messageContent = content.substring(endIndex + 1).trim();
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u76f4\u63a5\u63d0\u53d6\u6d88\u606f: '{}' \u8bf4: '{}'", (Object)playerName, (Object)messageContent);
                return new String[]{playerName, messageContent};
            }
        }
        return null;
    }

    private boolean isCommand(String text) {
        return text != null && text.startsWith("/");
    }

    private boolean isCurrentPlayer(String playerName) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && playerName != null) {
            String currentPlayerName = client.field_1724.method_5477().getString();
            return playerName.equalsIgnoreCase(currentPlayerName);
        }
        return false;
    }

    private boolean isSystemMessage(String content) {
        boolean isSystem = SYSTEM_MESSAGE_PATTERN.matcher(content).find();
        if (isSystem) {
            ChatTranslatorMod.LOGGER.info("\u5339\u914d\u5230\u7cfb\u7edf\u6d88\u606f: '{}'", (Object)content);
        }
        return isSystem;
    }

    private boolean isOwnTranslatedMessage(String content) {
        boolean isTranslated;
        boolean bl = isTranslated = content.contains("[\u8bd1]") || content.contains("[\u539f]") || content.contains("[\u8bd1\u6587]") || content.contains("[\u539f\u6587]");
        if (isTranslated) {
            ChatTranslatorMod.LOGGER.info("\u5339\u914d\u5230\u5df2\u7ffb\u8bd1\u6d88\u606f: '{}'", (Object)content);
        }
        return isTranslated;
    }

    private boolean containsChineseCharacters(String text) {
        return text != null && !text.isEmpty() && CHINESE_PATTERN.matcher(text).find();
    }

    private boolean isChineseAbbreviation(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        String normalized = text.toLowerCase().trim();
        if (CHINESE_ABBREVIATIONS.contains(normalized)) {
            return true;
        }
        for (String abbr : CHINESE_ABBREVIATIONS) {
            if (!normalized.matches("\\s*" + Pattern.quote(abbr) + "\\s*[!?,.\u3002\uff01\uff1f\uff0c]*\\s*")) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSkipTranslation(String content) {
        if (content == null || content.isEmpty()) {
            return true;
        }
        boolean containsChinese = this.containsChineseCharacters(content);
        if (containsChinese) {
            ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u8df3\u8fc7\u5305\u542b\u4e2d\u6587\u7684\u6d88\u606f: '{}'", (Object)content);
            return true;
        }
        boolean isAbbreviation = this.isChineseAbbreviation(content);
        if (isAbbreviation) {
            ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u8df3\u8fc7\u5305\u542b\u4e2d\u6587\u6216\u4e2d\u6587\u7f29\u5199\u7684\u5185\u5bb9: '{}'", (Object)content);
            return true;
        }
        return false;
    }

    private void translateMessage(String content) {
        if (content == null || content.trim().isEmpty()) {
            this.pendingTranslations.remove(content);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long lastCall = this.lastApiCallTime.get();
        long timeSinceLastCall = currentTime - lastCall;
        if (lastCall > 0L && timeSinceLastCall < 1300L) {
            long delay = 1300L - timeSinceLastCall;
            this.scheduler.schedule(() -> this.translateMessage(content), delay, TimeUnit.MILLISECONDS);
            return;
        }
        this.lastApiCallTime.set(currentTime);
        ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u6b63\u5728\u7ffb\u8bd1: '{}'", (Object)content);
        CompletableFuture<String> futureTranslation = TranslationService.translateAsync(content);
        ((CompletableFuture)futureTranslation.thenAccept(translatedText -> {
            this.pendingTranslations.remove(content);
            if (translatedText != null && !translatedText.trim().isEmpty() && !translatedText.equals(content)) {
                if (translatedText.contains("\u514d\u8d39\u7528\u6237\u63a5\u53e3\u8bbf\u95ee\u9891\u7387") || translatedText.contains("something went wrong")) {
                    ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u68c0\u6d4b\u5230API\u9891\u7387\u9650\u5236\uff0c\u5c06\u6d88\u606f\u91cd\u65b0\u6392\u961f: '{}'", (Object)content);
                    this.pendingTranslations.add(content);
                    this.scheduler.schedule(() -> this.translateMessage(content), 1300L, TimeUnit.MILLISECONDS);
                    return;
                }
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u7ffb\u8bd1\u7ed3\u679c: '{}' -> '{}'", (Object)content, translatedText);
                String sender = this.messageSenders.getOrDefault(content, "\u672a\u77e5\u73a9\u5bb6");
                this.messageSenders.remove(content);
                class_5250 translatedMessage = this.createTranslatedMessage(content, (String)translatedText, sender);
                int translationDelay = ModConfig.getTranslationDelay();
                if (translationDelay > 0) {
                    this.scheduler.schedule(() -> class_310.method_1551().execute(() -> this.sendTranslationToChat((class_2561)translatedMessage)), (long)translationDelay, TimeUnit.MILLISECONDS);
                } else {
                    class_310.method_1551().execute(() -> this.sendTranslationToChat((class_2561)translatedMessage));
                }
            } else {
                ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u8df3\u8fc7\u7ffb\u8bd1: '{}'", (Object)content);
            }
        })).exceptionally(e -> {
            this.pendingTranslations.remove(content);
            ChatTranslatorMod.LOGGER.error("\u7ffb\u8bd1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
            return null;
        });
    }

    private class_5250 createTranslatedMessage(String original, String translated, String sender) {
        class_5250 messageText;
        MessageData messageData = MessageManager.addMessage(original, translated, sender);
        String messageId = messageData.getId();
        if (ModConfig.shouldShowOriginalMessage()) {
            messageText = class_2561.method_43470((String)("<" + sender + "> ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"[\u539f\u6587] ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)original).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)("\n<" + sender + "> ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"[\u8bd1\u6587] ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)translated).method_27692(class_124.field_1068));
        } else {
            class_5250 prefix = class_2561.method_43470((String)("<" + sender + "> ")).method_27692(class_124.field_1075);
            String currentTag = messageData.isShowTranslated() ? "[\u8bd1] " : "[\u539f] ";
            class_5250 tagText = class_2561.method_43470((String)currentTag).method_27692(messageData.isShowTranslated() ? class_124.field_1065 : class_124.field_1080);
            String currentText = messageData.getCurrentText();
            String hoverText = messageData.isShowTranslated() ? "\u70b9\u51fb\u67e5\u770b\u539f\u6587" : "\u70b9\u51fb\u67e5\u770b\u8bd1\u6587";
            class_5250 clickableText = class_2561.method_43470((String)currentText).method_27692(class_124.field_1068).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/chattranslator:toggle " + messageId)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)hoverText))));
            messageText = prefix.method_10852((class_2561)tagText).method_10852((class_2561)clickableText);
        }
        return messageText;
    }

    private void sendTranslationToChat(class_2561 translatedMessage) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            ChatTranslatorMod.LOGGER.info("[\u5904\u7406\u5668] \u53d1\u9001\u7ffb\u8bd1\u6d88\u606f\u5230\u804a\u5929\u6846: '{}'", (Object)translatedMessage.getString());
            client.field_1705.method_1743().method_1812(translatedMessage);
        } else {
            ChatTranslatorMod.LOGGER.warn("[\u5904\u7406\u5668] \u65e0\u6cd5\u53d1\u9001\u7ffb\u8bd1\u6d88\u606f\uff1a\u73a9\u5bb6\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    public void cleanup() {
        this.scheduler.shutdown();
        this.pendingTranslations.clear();
        this.messageSenders.clear();
    }
}

