/*
 * Decompiled with CFR 0.152.
 */
package com.trator.chatranslator;

import com.trator.chatranslator.ChatTranslatorMod;
import com.trator.chatranslator.config.ModConfig;
import com.trator.chatranslator.data.MessageData;
import com.trator.chatranslator.data.MessageManager;
import com.trator.chatranslator.network.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ChatMessageListener {
    private static final Pattern SYSTEM_MESSAGE_PATTERN = Pattern.compile("^\\[\u7cfb\u7edf\\]|^\\[\u8bd1|^\\[\u539f\u6587]|\\[(.+)\u52a0\u5165\u4e86\u6e38\u620f\\]|\\[(.+)\u79bb\u5f00\u4e86\u6e38\u620f\\]");
    private static final Pattern PLAYER_MESSAGE_PATTERN = Pattern.compile("<([^>]+)>\\s+(.+)");
    private static final Pattern PREFIXED_PLAYER_MESSAGE_PATTERN = Pattern.compile("\\[.+\\].*<([^>]+)>\\s+(.+)");
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^/.*");
    private static final Pattern ALT_PLAYER_MESSAGE_PATTERN = Pattern.compile("\\[CHAT\\]\\s+<([^>]+)>\\s+(.+)");
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final Set<String> CHINESE_ABBREVIATIONS = new HashSet<String>(Arrays.asList("gg", "nb", "xswl", "nmsl", "sb", "lz", "fvv", "fw", "233", "666"));
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    private static final long API_RATE_LIMIT_MS = 1300L;
    private static final AtomicLong lastApiCallTime = new AtomicLong(0L);
    private static final Queue<TranslationRequest> translationQueue = new ConcurrentLinkedQueue<TranslationRequest>();
    private static final Set<String> pendingTranslations = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ConcurrentHashMap<String, String> messageSenders = new ConcurrentHashMap();

    private static boolean containsChineseCharacters(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return CHINESE_PATTERN.matcher(text).find();
    }

    private static boolean isChineseAbbreviation(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        String normalized = text.toLowerCase().trim();
        if (CHINESE_ABBREVIATIONS.contains(normalized)) {
            return true;
        }
        for (String abbr : CHINESE_ABBREVIATIONS) {
            if (!normalized.matches("\\s*" + Pattern.quote(abbr) + "\\s*[!?,.\u3002\uff01\uff1f\uff0c]*\\s*")) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldSkipTranslation(String content) {
        if (content == null || content.isEmpty()) {
            return true;
        }
        boolean containsChinese = ChatMessageListener.containsChineseCharacters(content);
        if (containsChinese) {
            ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5305\u542b\u4e2d\u6587\u7684\u6d88\u606f: '{}'", (Object)content);
            return true;
        }
        boolean isAbbreviation = ChatMessageListener.isChineseAbbreviation(content);
        if (isAbbreviation) {
            ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u4e2d\u6587\u7f51\u7edc\u7f29\u5199: '{}'", (Object)content);
            return true;
        }
        return false;
    }

    private static String[] extractChatContent(String rawText) {
        if (rawText == null || rawText.isEmpty()) {
            return null;
        }
        ChatTranslatorMod.LOGGER.info("[\u63d0\u53d6] \u5c1d\u8bd5\u63d0\u53d6\u6d88\u606f\u5185\u5bb9: '{}'", (Object)rawText);
        Matcher prefixedMatcher = PREFIXED_PLAYER_MESSAGE_PATTERN.matcher(rawText);
        if (prefixedMatcher.find() && prefixedMatcher.groupCount() >= 2) {
            String playerName = prefixedMatcher.group(1);
            String content = prefixedMatcher.group(2).trim();
            ChatTranslatorMod.LOGGER.info("[\u63d0\u53d6] \u901a\u8fc7\u524d\u7f00\u6b63\u5219\u8868\u8fbe\u5f0f\u63d0\u53d6: \u73a9\u5bb6='{}', \u5185\u5bb9='{}'", (Object)playerName, (Object)content);
            return new String[]{playerName, content};
        }
        Matcher simpleMatcher = PLAYER_MESSAGE_PATTERN.matcher(rawText);
        if (simpleMatcher.find() && simpleMatcher.groupCount() >= 2) {
            String playerName = simpleMatcher.group(1);
            String content = simpleMatcher.group(2).trim();
            ChatTranslatorMod.LOGGER.info("[\u63d0\u53d6] \u901a\u8fc7\u7b80\u5355\u6b63\u5219\u8868\u8fbe\u5f0f\u63d0\u53d6: \u73a9\u5bb6='{}', \u5185\u5bb9='{}'", (Object)playerName, (Object)content);
            return new String[]{playerName, content};
        }
        if (rawText.contains("<") && rawText.contains(">")) {
            int startIndex = rawText.lastIndexOf(60);
            int endIndex = rawText.indexOf(62, startIndex);
            if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                String playerName = rawText.substring(startIndex + 1, endIndex);
                String content = rawText.substring(endIndex + 1).trim();
                ChatTranslatorMod.LOGGER.info("[\u63d0\u53d6] \u901a\u8fc7\u7b80\u5316\u63d0\u53d6: \u73a9\u5bb6='{}', \u5185\u5bb9='{}'", (Object)playerName, (Object)content);
                return new String[]{playerName, content};
            }
        }
        ChatTranslatorMod.LOGGER.info("[\u63d0\u53d6] \u672a\u80fd\u63d0\u53d6\u73a9\u5bb6\u540d\u548c\u5185\u5bb9");
        return null;
    }

    public static void register() {
        ClientReceiveMessageEvents.ALLOW_CHAT.register((message, signedMessage, sender, params, receptionTimestamp) -> {
            try {
                String[] extracted;
                String textContent = message.getString();
                ChatTranslatorMod.LOGGER.info("[ALLOW_CHAT] \u6355\u83b7\u804a\u5929\u6d88\u606f: '{}'", (Object)textContent);
                boolean isTranslationEnabled = ModConfig.isTranslationEnabled();
                boolean isOwnMessage = ChatMessageListener.isOwnMessage(textContent);
                boolean isCommand = ChatMessageListener.isCommand(textContent);
                ChatTranslatorMod.LOGGER.info("[\u8c03\u8bd5] \u7ffb\u8bd1\u5f00\u542f: {}, \u81ea\u5df1\u7684\u6d88\u606f: {}, \u662f\u547d\u4ee4: {}", new Object[]{isTranslationEnabled, isOwnMessage, isCommand});
                if (isTranslationEnabled && !isOwnMessage && !isCommand && (extracted = ChatMessageListener.extractChatContent(textContent)) != null) {
                    String playerName = extracted[0];
                    String content = extracted[1];
                    if (ChatMessageListener.isCurrentPlayer(playerName)) {
                        ChatTranslatorMod.LOGGER.info("[ALLOW_CHAT] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)content);
                        return true;
                    }
                    if (ChatMessageListener.shouldSkipTranslation(content)) {
                        ChatTranslatorMod.LOGGER.info("[ALLOW_CHAT] \u8df3\u8fc7\u4e2d\u6587\u5185\u5bb9\u6216\u4e2d\u6587\u7f29\u5199: '{}'", (Object)content);
                        return true;
                    }
                    messageSenders.put(content, playerName);
                    if (!pendingTranslations.contains(content)) {
                        pendingTranslations.add(content);
                        ChatTranslatorMod.LOGGER.info("[ALLOW_CHAT] \u5c06\u6d88\u606f\u6dfb\u52a0\u5230\u7ffb\u8bd1\u961f\u5217: '{}'", (Object)content);
                        ChatMessageListener.enqueueTranslation(content, true);
                    }
                }
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("\u5904\u7406ALLOW_CHAT\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            return true;
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            try {
                String[] extracted;
                String rawText = message.getString();
                if (ChatMessageListener.isCommand(rawText) || SYSTEM_MESSAGE_PATTERN.matcher(rawText).find()) {
                    return true;
                }
                ChatTranslatorMod.LOGGER.info("[ALLOW_GAME] \u6536\u5230\u6d88\u606f: '{}'", (Object)rawText);
                if (ModConfig.isTranslationEnabled() && !ChatMessageListener.isOwnMessage(rawText) && (extracted = ChatMessageListener.extractChatContent(rawText)) != null) {
                    String playerName = extracted[0];
                    String content = extracted[1];
                    if (ChatMessageListener.isCurrentPlayer(playerName)) {
                        ChatTranslatorMod.LOGGER.info("[ALLOW_GAME] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)content);
                        return true;
                    }
                    if (ChatMessageListener.shouldSkipTranslation(content)) {
                        ChatTranslatorMod.LOGGER.info("[ALLOW_GAME] \u8df3\u8fc7\u4e2d\u6587\u5185\u5bb9\u6216\u4e2d\u6587\u7f29\u5199: '{}'", (Object)content);
                        return true;
                    }
                    messageSenders.put(content, playerName);
                    if (!pendingTranslations.contains(content)) {
                        pendingTranslations.add(content);
                        ChatTranslatorMod.LOGGER.info("[ALLOW_GAME] \u5c06\u6d88\u606f\u6dfb\u52a0\u5230\u7ffb\u8bd1\u961f\u5217: '{}'", (Object)content);
                        ChatMessageListener.enqueueTranslation(content, false);
                    }
                }
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("\u5904\u7406ALLOW_GAME\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            return true;
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            try {
                String rawText = message.getString();
                if (ChatMessageListener.isCommand(rawText) || SYSTEM_MESSAGE_PATTERN.matcher(rawText).find()) {
                    return;
                }
                ChatTranslatorMod.LOGGER.info("[GAME] \u6536\u5230\u6d88\u606f: '{}'", (Object)rawText);
                if (!overlay && ModConfig.isTranslationEnabled() && !ChatMessageListener.isOwnMessage(rawText)) {
                    String[] extracted = ChatMessageListener.extractChatContent(rawText);
                    if (extracted != null) {
                        String playerName = extracted[0];
                        String content = extracted[1];
                        if (ChatMessageListener.isCurrentPlayer(playerName)) {
                            ChatTranslatorMod.LOGGER.info("[GAME] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)content);
                            return;
                        }
                        if (ChatMessageListener.shouldSkipTranslation(content)) {
                            ChatTranslatorMod.LOGGER.info("[GAME] \u8df3\u8fc7\u4e2d\u6587\u5185\u5bb9\u6216\u4e2d\u6587\u7f29\u5199: '{}'", (Object)content);
                            return;
                        }
                        messageSenders.put(content, playerName);
                        if (!pendingTranslations.contains(content)) {
                            pendingTranslations.add(content);
                            ChatTranslatorMod.LOGGER.info("[GAME] \u5c06\u6d88\u606f\u6dfb\u52a0\u5230\u7ffb\u8bd1\u961f\u5217: '{}'", (Object)content);
                            ChatMessageListener.enqueueTranslation(content, true);
                            return;
                        }
                    } else {
                        ChatMessageListener.processMessage(message, rawText);
                    }
                }
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("\u5904\u7406GAME\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        });
        ChatMessageListener.startTranslationQueueProcessor();
        ChatTranslatorMod.LOGGER.info("\u804a\u5929\u7ffb\u8bd1\u76d1\u542c\u5668\u5df2\u6ce8\u518c! \u7b49\u5f85\u73a9\u5bb6\u53d1\u9001\u6d88\u606f...");
        ChatTranslatorMod.LOGGER.info("\u7279\u522b\u63d0\u793a\uff1a\u5c1d\u8bd5\u4f7f\u7528/translator status\u67e5\u770b\u5f53\u524d\u914d\u7f6e\u72b6\u6001");
    }

    private static void startTranslationQueueProcessor() {
        SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                ChatMessageListener.processTranslationQueue();
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("\u5904\u7406\u7ffb\u8bd1\u961f\u5217\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static void processTranslationQueue() {
        if (translationQueue.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long lastCall = lastApiCallTime.get();
        long timeSinceLastCall = currentTime - lastCall;
        if (lastCall > 0L && timeSinceLastCall < 1300L) {
            return;
        }
        TranslationRequest request = translationQueue.poll();
        if (request == null) {
            return;
        }
        if (ChatMessageListener.shouldSkipTranslation(request.content)) {
            ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u8df3\u8fc7\u5305\u542b\u4e2d\u6587\u6216\u4e2d\u6587\u7f29\u5199\u7684\u5185\u5bb9: '{}'", (Object)request.content);
            pendingTranslations.remove(request.content);
            return;
        }
        lastApiCallTime.set(currentTime);
        if (request.immediate) {
            ChatMessageListener.translateMessageWithRateLimit(request.content);
        } else {
            ChatMessageListener.translateAndSendWithRateLimit(request.content);
        }
    }

    private static void enqueueTranslation(String content, boolean immediate) {
        translationQueue.add(new TranslationRequest(content, immediate));
    }

    private static boolean isCommand(String text) {
        return text.startsWith("/") || COMMAND_PATTERN.matcher(text).matches();
    }

    private static boolean isCurrentPlayer(String playerName) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && playerName != null) {
            String currentPlayerName = client.field_1724.method_5477().getString();
            return playerName.equalsIgnoreCase(currentPlayerName);
        }
        return false;
    }

    private static void translateMessageWithRateLimit(String content) {
        CompletableFuture<String> futureTranslation = TranslationService.translateAsync(content);
        ((CompletableFuture)futureTranslation.thenAccept(translatedText -> {
            try {
                pendingTranslations.remove(content);
                if (translatedText != null && !translatedText.trim().isEmpty() && !translatedText.equals(content)) {
                    if (translatedText.contains("\u514d\u8d39\u7528\u6237\u63a5\u53e3\u8bbf\u95ee\u9891\u7387") || translatedText.contains("something went wrong")) {
                        ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u68c0\u6d4b\u5230API\u9891\u7387\u9650\u5236\uff0c\u5c06\u6d88\u606f\u91cd\u65b0\u6392\u961f: '{}'", (Object)content);
                        pendingTranslations.add(content);
                        ChatMessageListener.enqueueTranslation(content, false);
                        return;
                    }
                    ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u7ffb\u8bd1\u7ed3\u679c: '{}' -> '{}'", (Object)content, translatedText);
                    String sender = messageSenders.getOrDefault(content, "\u672a\u77e5\u73a9\u5bb6");
                    messageSenders.remove(content);
                    class_5250 translatedMessage = ChatMessageListener.createTranslatedMessage(content, translatedText, sender);
                    class_310.method_1551().execute(() -> ChatMessageListener.sendTranslationToChat((class_2561)translatedMessage));
                }
            }
            catch (Exception e) {
                ChatTranslatorMod.LOGGER.error("\u5904\u7406\u7ffb\u8bd1\u7ed3\u679c\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        })).exceptionally(e -> {
            pendingTranslations.remove(content);
            ChatTranslatorMod.LOGGER.error("\u7ffb\u8bd1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
            return null;
        });
    }

    private static void processRawMessage(String rawText) {
        if (ChatMessageListener.isCommand(rawText) || SYSTEM_MESSAGE_PATTERN.matcher(rawText).find()) {
            return;
        }
        String[] extracted = ChatMessageListener.extractChatContent(rawText);
        if (extracted != null) {
            String playerName = extracted[0];
            String content = extracted[1];
            if (ChatMessageListener.isCurrentPlayer(playerName)) {
                ChatTranslatorMod.LOGGER.info("[\u539f\u59cb\u5904\u7406] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f");
                return;
            }
            if (ChatMessageListener.isCommand(content)) {
                ChatTranslatorMod.LOGGER.info("[\u539f\u59cb\u5904\u7406] \u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
                return;
            }
            ChatTranslatorMod.LOGGER.info("[\u539f\u59cb\u5904\u7406] \u63d0\u53d6\u73a9\u5bb6\u6d88\u606f: '{}' \u8bf4: '{}'", (Object)playerName, (Object)content);
            messageSenders.put(content, playerName);
            if (!pendingTranslations.contains(content)) {
                pendingTranslations.add(content);
                ChatMessageListener.enqueueTranslation(content, false);
            }
        } else {
            ChatTranslatorMod.LOGGER.info("[\u539f\u59cb\u5904\u7406] \u65e0\u6cd5\u63d0\u53d6\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)rawText);
        }
    }

    private static void processMessageLater(String textContent) {
        if (ChatMessageListener.isCommand(textContent) || SYSTEM_MESSAGE_PATTERN.matcher(textContent).find()) {
            return;
        }
        SCHEDULER.schedule(() -> {
            String[] extracted = ChatMessageListener.extractChatContent(textContent);
            if (extracted != null) {
                String playerName = extracted[0];
                String content = extracted[1];
                if (ChatMessageListener.isCurrentPlayer(playerName)) {
                    ChatTranslatorMod.LOGGER.info("[\u5ef6\u8fdf\u5904\u7406] \u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f");
                    return;
                }
                if (ChatMessageListener.isCommand(content)) {
                    ChatTranslatorMod.LOGGER.info("[\u5ef6\u8fdf\u5904\u7406] \u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
                    return;
                }
                ChatTranslatorMod.LOGGER.info("[\u5ef6\u8fdf\u5904\u7406] \u63d0\u53d6\u73a9\u5bb6\u6d88\u606f: '{}' \u8bf4: '{}'", (Object)playerName, (Object)content);
                messageSenders.put(content, playerName);
                if (!pendingTranslations.contains(content)) {
                    pendingTranslations.add(content);
                    ChatMessageListener.enqueueTranslation(content, false);
                }
            } else if (!pendingTranslations.contains(textContent)) {
                ChatTranslatorMod.LOGGER.info("[\u5ef6\u8fdf\u5904\u7406] \u68c0\u6d4b\u5230\u53ef\u80fd\u7684\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)textContent);
                ChatMessageListener.processRawMessage(textContent);
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private static boolean isOwnMessage(String content) {
        boolean containsTranslationTag;
        boolean bl = containsTranslationTag = content.contains("[\u539f\u6587]") || content.contains("[\u8bd1\u6587]") || content.contains("[\u8bd1]") || content.contains("[\u539f]");
        if (containsTranslationTag) {
            ChatTranslatorMod.LOGGER.info("[\u68c0\u6d4b] \u8bc6\u522b\u4e3a\u7ffb\u8bd1\u6d88\u606f: '{}'", (Object)content);
        }
        return containsTranslationTag;
    }

    private static void processMessage(class_2561 message, String textContent) {
        if (ChatMessageListener.isCommand(textContent) || SYSTEM_MESSAGE_PATTERN.matcher(textContent).find()) {
            return;
        }
        ChatTranslatorMod.LOGGER.info("\u5904\u7406\u6d88\u606f: '{}'", (Object)textContent);
        Matcher prefixedMatcher = PREFIXED_PLAYER_MESSAGE_PATTERN.matcher(textContent);
        if (prefixedMatcher.find() && prefixedMatcher.groupCount() >= 2) {
            String playerName = prefixedMatcher.group(1);
            String content = prefixedMatcher.group(2).trim();
            if (ChatMessageListener.isCurrentPlayer(playerName)) {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f");
                return;
            }
            if (ChatMessageListener.isCommand(content)) {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
                return;
            }
            ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u5e26\u524d\u7f00\u7684\u73a9\u5bb6\u6d88\u606f: '{}' \u8bf4: '{}'", (Object)playerName, (Object)content);
            messageSenders.put(content, playerName);
            if (!pendingTranslations.contains(content)) {
                pendingTranslations.add(content);
                ChatMessageListener.enqueueTranslation(content, false);
            }
            return;
        }
        Matcher playerMatcher = PLAYER_MESSAGE_PATTERN.matcher(textContent);
        if (!playerMatcher.find()) {
            playerMatcher = ALT_PLAYER_MESSAGE_PATTERN.matcher(textContent);
        }
        if (playerMatcher.find() && playerMatcher.groupCount() >= 2) {
            String playerName = playerMatcher.group(1);
            if (ChatMessageListener.isCurrentPlayer(playerName)) {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f");
                return;
            }
            String content = playerMatcher.group(2).trim();
            if (ChatMessageListener.isCommand(content)) {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
                return;
            }
            ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u73a9\u5bb6\u6d88\u606f: '{}' \u8bf4: '{}'", (Object)playerName, (Object)content);
            messageSenders.put(content, playerName);
            if (!pendingTranslations.contains(content)) {
                pendingTranslations.add(content);
                ChatMessageListener.enqueueTranslation(content, false);
            } else {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5df2\u5728\u5904\u7406\u7684\u6d88\u606f: '{}'", (Object)content);
            }
        } else if (!SYSTEM_MESSAGE_PATTERN.matcher(textContent).find()) {
            if (ChatMessageListener.isCommand(textContent)) {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)textContent);
                return;
            }
            ChatTranslatorMod.LOGGER.info("\u68c0\u6d4b\u5230\u5176\u4ed6\u6d88\u606f\u683c\u5f0f: '{}'", (Object)textContent);
            if (textContent.contains("[CHAT]") || textContent.contains("<") && textContent.contains(">")) {
                ChatTranslatorMod.LOGGER.info("\u7591\u4f3c\u804a\u5929\u6d88\u606f: '{}'", (Object)textContent);
                Pattern extractPattern = Pattern.compile(".*<([^>]+)>\\s*(.+)");
                Matcher extractMatcher = extractPattern.matcher(textContent);
                if (extractMatcher.find()) {
                    String playerName = extractMatcher.group(1);
                    if (ChatMessageListener.isCurrentPlayer(playerName)) {
                        ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5f53\u524d\u73a9\u5bb6\u6d88\u606f");
                        return;
                    }
                    String content = extractMatcher.group(2).trim();
                    if (ChatMessageListener.isCommand(content)) {
                        ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
                        return;
                    }
                    ChatTranslatorMod.LOGGER.info("\u63d0\u53d6\u5230\u73a9\u5bb6 '{}' \u7684\u6d88\u606f: '{}'", (Object)playerName, (Object)content);
                    messageSenders.put(content, playerName);
                    if (!pendingTranslations.contains(content)) {
                        pendingTranslations.add(content);
                        ChatMessageListener.enqueueTranslation(content, false);
                    }
                    return;
                }
            }
            if (!pendingTranslations.contains(textContent) && !textContent.contains("/")) {
                pendingTranslations.add(textContent);
                ChatMessageListener.enqueueTranslation(textContent, false);
            } else {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u5df2\u5728\u5904\u7406\u7684\u6d88\u606f\u6216\u975e\u73a9\u5bb6\u6d88\u606f: '{}'", (Object)textContent);
            }
        } else {
            ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u7cfb\u7edf\u6d88\u606f: '{}'", (Object)textContent);
        }
    }

    private static void translateAndSendWithRateLimit(String content) {
        if (content == null || content.trim().isEmpty()) {
            ChatTranslatorMod.LOGGER.debug("\u7a7a\u5185\u5bb9\uff0c\u8df3\u8fc7\u7ffb\u8bd1");
            pendingTranslations.remove(content);
            return;
        }
        if (ChatMessageListener.isCommand(content)) {
            ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u547d\u4ee4: '{}'", (Object)content);
            pendingTranslations.remove(content);
            return;
        }
        ChatTranslatorMod.LOGGER.info("\u6b63\u5728\u7ffb\u8bd1: '{}'", (Object)content);
        CompletableFuture<String> futureTranslation = TranslationService.translateAsync(content);
        int translationDelay = ModConfig.getTranslationDelay();
        ((CompletableFuture)futureTranslation.thenAccept(translatedText -> {
            pendingTranslations.remove(content);
            if (translatedText != null && !translatedText.trim().isEmpty() && !translatedText.equals(content)) {
                if (translatedText.contains("\u514d\u8d39\u7528\u6237\u63a5\u53e3\u8bbf\u95ee\u9891\u7387") || translatedText.contains("something went wrong")) {
                    ChatTranslatorMod.LOGGER.info("[\u7ffb\u8bd1\u961f\u5217] \u68c0\u6d4b\u5230API\u9891\u7387\u9650\u5236\uff0c\u5c06\u6d88\u606f\u91cd\u65b0\u6392\u961f: '{}'", (Object)content);
                    pendingTranslations.add(content);
                    ChatMessageListener.enqueueTranslation(content, false);
                    return;
                }
                ChatTranslatorMod.LOGGER.info("\u7ffb\u8bd1\u7ed3\u679c: '{}' -> '{}'", (Object)content, translatedText);
                String sender = messageSenders.getOrDefault(content, "\u672a\u77e5\u73a9\u5bb6");
                messageSenders.remove(content);
                class_5250 translatedMessage = ChatMessageListener.createTranslatedMessage(content, translatedText, sender);
                if (translationDelay > 0) {
                    SCHEDULER.schedule(() -> class_310.method_1551().execute(() -> ChatMessageListener.sendTranslationToChat((class_2561)translatedMessage)), (long)translationDelay, TimeUnit.MILLISECONDS);
                } else {
                    class_310.method_1551().execute(() -> ChatMessageListener.sendTranslationToChat((class_2561)translatedMessage));
                }
            } else {
                ChatTranslatorMod.LOGGER.info("\u8df3\u8fc7\u7ffb\u8bd1: '{}'", (Object)content);
            }
        })).exceptionally(e -> {
            pendingTranslations.remove(content);
            ChatTranslatorMod.LOGGER.error("\u7ffb\u8bd1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
            return null;
        });
    }

    private static class_5250 createTranslatedMessage(String original, String translated, String sender) {
        class_5250 messageText;
        MessageData messageData = MessageManager.addMessage(original, translated);
        String messageId = messageData.getId();
        if (ModConfig.shouldShowOriginalMessage()) {
            messageText = class_2561.method_43470((String)("<" + sender + "> ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"[\u539f\u6587] ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)original).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)("\n<" + sender + "> ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"[\u8bd1\u6587] ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)translated).method_27692(class_124.field_1068));
        } else {
            class_5250 prefix = class_2561.method_43470((String)("<" + sender + "> ")).method_27692(class_124.field_1075);
            String currentTag = messageData.isShowTranslated() ? "[\u8bd1] " : "[\u539f] ";
            class_5250 tagText = class_2561.method_43470((String)currentTag).method_27692(messageData.isShowTranslated() ? class_124.field_1065 : class_124.field_1080);
            String currentText = messageData.getCurrentText();
            String hoverText = messageData.isShowTranslated() ? "\u70b9\u51fb\u67e5\u770b\u539f\u6587" : "\u70b9\u51fb\u67e5\u770b\u8bd1\u6587";
            class_5250 clickableText = class_2561.method_43470((String)currentText).method_27692(class_124.field_1068).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/chattranslator:toggle " + messageId)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)hoverText))));
            messageText = prefix.method_10852((class_2561)tagText).method_10852((class_2561)clickableText);
        }
        return messageText;
    }

    private static void sendTranslationToChat(class_2561 translatedMessage) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            ChatTranslatorMod.LOGGER.info("\u53d1\u9001\u7ffb\u8bd1\u6d88\u606f\u5230\u804a\u5929\u6846: '{}'", (Object)translatedMessage.getString());
            client.field_1705.method_1743().method_1812(translatedMessage);
        } else {
            ChatTranslatorMod.LOGGER.warn("\u65e0\u6cd5\u53d1\u9001\u7ffb\u8bd1\u6d88\u606f\uff1a\u73a9\u5bb6\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    private static class TranslationRequest {
        final String content;
        final boolean immediate;

        TranslationRequest(String content, boolean immediate) {
            this.content = content;
            this.immediate = immediate;
        }
    }
}

