from flask import Flask, request, jsonify, session, render_template
from flask_cors import CORS
import json
import os

app = Flask(__name__)
app.secret_key = 'your_secret_key_here'
CORS(app)

# 模拟数据库
DATA_FILE = 'data.json'

def load_data():
    if os.path.exists(DATA_FILE):
        with open(DATA_FILE, 'r', encoding='utf-8') as f:
            return json.load(f)
    else:
        # 初始化数据
        data = {
            'students': [
                {
                    'id': i + 1,
                    'name': f'学生{i+1}',
                    'score': 0,
                    'hasRecord': False,
                    'recordDetails': '',
                    'seat': i + 1
                } for i in range(24)
            ],
            'users': [
                {
                    'username': 'admin',
                    'password': 'admin123'
                }
            ]
        }
        save_data(data)
        return data

def save_data(data):
    with open(DATA_FILE, 'w', encoding='utf-8') as f:
        json.dump(data, f, ensure_ascii=False, indent=2)

# 主页面
@app.route('/')
def index():
    return render_template('index.html')

# 获取所有学生
@app.route('/api/students', methods=['GET'])
def get_students():
    data = load_data()
    return jsonify(data['students'])

# 更新学生分数
@app.route('/api/students/<int:student_id>/score', methods=['POST'])
def update_student_score(student_id):
    data = load_data()
    student = next((s for s in data['students'] if s['id'] == student_id), None)
    
    if student:
        points = request.json.get('points', 0)
        student['score'] += points
        save_data(data)
        return jsonify({'success': True})
    
    return jsonify({'success': False}), 404

# 更新学生记过记录
@app.route('/api/students/<int:student_id>/record', methods=['POST'])
def update_student_record(student_id):
    data = load_data()
    student = next((s for s in data['students'] if s['id'] == student_id), None)
    
    if student:
        has_record = request.json.get('hasRecord', False)
        record_details = request.json.get('recordDetails', '')
        
        student['hasRecord'] = has_record
        student['recordDetails'] = record_details
        save_data(data)
        return jsonify({'success': True})
    
    return jsonify({'success': False}), 404

# 管理员登录
@app.route('/api/login', methods=['POST'])
def login():
    data = load_data()
    username = request.json.get('username')
    password = request.json.get('password')
    
    user = next((u for u in data['users'] if u['username'] == username and u['password'] == password), None)
    
    if user:
        session['logged_in'] = True
        session['username'] = username
        return jsonify({'success': True})
    
    return jsonify({'success': False}), 401

if __name__ == '__main__':
    # 关闭调试模式，使用单进程
    app.run(debug=False, host='0.0.0.0', port=5000)